<?php
/* --------------------------------------------------------------
   ParcelServiceServiceProvider.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService;

use Doctrine\DBAL\Connection;
use Gambio\Admin\ParcelService\Interfaces\ParcelServiceService;
use Gambio\Admin\ParcelService\ParcelServiceService as ParcelServiceServiceImp;
use Gambio\Admin\ParcelService\Repository\ParcelServiceMapper;
use Gambio\Admin\ParcelService\Repository\ParcelServiceReader;
use Gambio\Admin\ParcelService\Repository\ParcelServiceRepository;
use Gambio\Admin\ParcelService\Repository\ParcelServiceWriter;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractServiceProvider;
use Gambio\Core\Language\LanguageService;
use Psr\EventDispatcher\EventDispatcherInterface;

/**
 * Class ParcelServiceServiceProvider
 *
 * @package Gambio\Admin\ParcelService
 * @codeCoverageIgnore
 */
class ParcelServiceServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritcDoc
     */
    public function provides(): array
    {
        return [
            ParcelServiceService::class,
            ParcelServiceController::class,
        ];
    }
    
    
    /**
     * @inheritcDoc
     */
    public function register(): void
    {
        $this->application->share(ParcelServiceFactory::class);
        
        $this->application->share(ParcelServiceMapper::class)->addArgument(ParcelServiceFactory::class);
        
        $this->application->share(ParcelServiceReader::class)->addArgument(Connection::class);
        
        $this->application->share(ParcelServiceWriter::class)
            ->addArgument(Connection::class)
            ->addArgument(LanguageService::class);
        
        $this->application->share(ParcelServiceRepository::class)
            ->addArgument(ParcelServiceMapper::class)
            ->addArgument(ParcelServiceReader::class)
            ->addArgument(ParcelServiceWriter::class)
            ->addArgument(EventDispatcherInterface::class);
        
        $this->application->share(ParcelServiceService::class, ParcelServiceServiceImp::class)
            ->addArgument(ParcelServiceRepository::class);
        
        $this->application->share(ParcelServiceController::class)->addArgument(ParcelServiceService::class);
    }
}